// PredictedRating.java
// Version 0.4 
// Last Updated: 10/16/2000
// Used by RecommendationManager

// Change Log
// RP101600 - Standardize naming, tab spacing, and commenting.


package Alkindi.BusinessServices.BeanImpl;

import java.util.*;
import Alkindi.BusinessDataTypes.*;
import Alkindi.BusinessServices.*;

public class PredictedRating {
	
	// METHOD:	getPRrating
	// PURPOSE: 
	// INPUT:	SystemUser su
	// INPUT:	long productid
	// OUTPUT:	double PRrating
	//
	public double getPRrating(SystemUser su, long productid) throws AlkExcept
	{
		double PRrating = 0D;
		
		try {
			double A = .5, B = .5; // tunable parameters
			RecMgrDBUtils redb = new RecMgrDBUtils();
			Vector sd = redb.getPredictedRatingDB(su, productid);
			int i = 0;
			double numerator = 0;
			double denominator = 0;
			while (i < sd.size()){
				double n = Double.parseDouble((sd.elementAt(i+1)).toString());
				double b = Double.parseDouble((sd.elementAt(i+2)).toString());
				double r = Double.parseDouble((sd.elementAt(i+3)).toString());
				numerator = numerator + r*n*(Math.exp(A*b + B));
				denominator = denominator + n*(Math.exp(A*b + B)); 
				i = 4*(i+1);
			}

			PRrating = numerator / denominator;
		}
		catch(AlkExcept ae) {
			throw (AlkExcept)ae.fillInStackTrace();
		}
		catch(Exception e) {
			throw new AlkExcept(e.getMessage(), 2513);
		}
		return PRrating;
	}
}
